<?php
// Data loss rasio dan splitter
$lossRasio = [];
for ($i = 1; $i <= 100; $i++) {
    // Diambil dari tabel gambar (yang Anda kirim), sebagian data disesuaikan
    $lossRasio[$i] = match (true) {
        $i == 1 => 20.25,
        $i == 2 => 17.24,
        $i == 3 => 15.48,
        $i == 4 => 14.23,
        $i == 5 => 13.26,
        $i == 6 => 12.47,
        $i == 7 => 11.80,
        $i == 8 => 11.22,
        $i == 9 => 10.71,
        $i == 10 => 10.25,
        default => max(0.25, round(20.25 * pow(0.95, $i), 2)) // perkiraan jika tak tersedia
    };
}

$lossSplitter = [
    2 => 3, 4 => 8, 8 => 11, 16 => 15, 32 => 17, 64 => 20
];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Hitung Rasio</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 30px; }
        table { border-collapse: collapse; width: 500px; margin-bottom: 20px; }
        td, th { border: 1px solid #ccc; padding: 8px; }
        th { background-color: #f0f0f0; }
        .header { background-color: #b6d7a8; font-weight: bold; }
        .output { background-color: #f4cccc; font-size: 24px; text-align: center; font-weight: bold; }
        input[type="number"], input[type="text"] { width: 100%; padding: 5px; }
        .loss-label { background-color: #ffe599; }
    </style>
</head>
<body>

<h2>HITUNG RASIO</h2>

<table>
    <tr><td colspan="2" class="header">Input Power</td><td><input type="number" id="inputPower" value="7.00" step="0.01"></td></tr>
    <tr><td colspan="2" class="header">Rasio</td>
        <td>
            <input type="number" id="rasio1" value="5" step="1" min="1" max="99"> /
            <span id="rasio2">95</span>
        </td>
    </tr>
    <tr><td colspan="2" class="header">Insert Loss</td>
        <td><span id="insertLoss">13.26</span></td></tr>
    <tr><td colspan="2" class="header">Output Power</td>
        <td><span id="outputPower">-6.26</span></td></tr>
</table>

<table>
    <tr><td class="header">No. ODP</td><td><input type="text" id="noODP" value="ODP 1"></td></tr>
    <tr><td class="header">Splitter</td>
        <td><input type="number" id="splitter" value="16" step="1"></td>
    </tr>
    <tr><td class="header">Hasil Redaman</td>
        <td class="output"><span id="hasilRedaman">-21.26</span></td>
    </tr>
    <tr><td class="header loss-label">Loss Splitter</td>
        <td class="loss-label"><span id="lossSplitter">15</span></td>
    </tr>
</table>

<script>
    const lossRasio = <?= json_encode($lossRasio) ?>;
    const lossSplitter = <?= json_encode($lossSplitter) ?>;

    const inputPowerEl = document.getElementById('inputPower');
    const rasio1El = document.getElementById('rasio1');
    const rasio2El = document.getElementById('rasio2');
    const insertLossEl = document.getElementById('insertLoss');
    const outputPowerEl = document.getElementById('outputPower');
    const splitterEl = document.getElementById('splitter');
    const lossSplitterEl = document.getElementById('lossSplitter');
    const hasilRedamanEl = document.getElementById('hasilRedaman');

    function calculate() {
        const inputPower = parseFloat(inputPowerEl.value);
        const rasio1 = parseInt(rasio1El.value) || 0;
        const rasio2 = 100 - rasio1;
        rasio2El.textContent = rasio2;

        const insertLoss = lossRasio[rasio1] ?? 0;
        insertLossEl.textContent = insertLoss.toFixed(2);

        const outputPower = rasio1 - insertLoss;
        outputPowerEl.textContent = outputPower.toFixed(2);

        const splitter = parseInt(splitterEl.value);
        const lossSplit = lossSplitter[splitter] ?? 0;
        lossSplitterEl.textContent = lossSplit;

        const hasilRedaman = outputPower - lossSplit;
        hasilRedamanEl.textContent = hasilRedaman.toFixed(2);
    }

    // Jalankan perhitungan setiap kali input berubah
    [inputPowerEl, rasio1El, splitterEl].forEach(el => {
        el.addEventListener('input', calculate);
    });

    // Jalankan pertama kali
    calculate();
</script>

</body>
</html>
